require( "quest/recyclemachine/convout.lua" );
combine_speech_tables();

gold_token = 4;		-- give gold token on this token
recycling_award = 5;	-- give recycling award on this token

machine_label_text = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	bubble = false,
	outline_size = 0,
	font = "fonts/garamondpremierpro.mvec"; 
	anchor = ANCHOR.CENTER
};

flo_spec =
{
	name = "FLO";

	command = function(actor)
		actor:ModifySaySpec(flo_text_spec)
		actor:SetMode(MODE.FOLLOWCLICKS);
		
		if IsCheatMode() then
			--wait_fade();
			--addInventory(inv_desc_token);
			--addInventory(inv_desc_recyclable);
			--local recyclable_count = 32;
			--game:Set("recyclable_count", recyclable_count);
			--BAG_INV:SetInventoryOvertext("recyclable", tostring(recyclable_count));
		end;
	end;
};

recycle_machine_spec = 
{
	name = "RECYCLE_MACHINE";
	
	command = function(actor)
		prepare_actor_text(actor, beadmachine_text_spec);
		actor:ModifySaySpec { mouth_in_actor = { x = 500, y = 200 }, };
	end;
};

function machine_give_token(flo)
	flo:SetMode(MODE.CUTSCENE);
	local recyclable_count = game:Get("recyclable_count");
	local token_count = game:Get("token_count");
	local tokens_given = game:Get("tokens_given");
	
	if tokens_given == nil then
		tokens_given = 0;
	end
	
	sfx:PlaySFX("audio/sfx/recycle_bottle.ogg");
	game:ClearInvUsage();
	delay(60);
	
	while recyclable_count >= 15 do
		recyclable_count = recyclable_count - 15;
		
		if recyclable_count > 0 then
			BAG_INV:SetInventoryOvertext("recyclable", tostring(recyclable_count));
		else
			BAG_INV:RemoveInventory("recyclable");
		end
		
		tokens_given = tokens_given + 1;
		
		delay(5);
		scene:Spawn(token_spec);
		if tokens_given == gold_token then
			scene.TOKEN:LoadImage("goldtoken");
		end
		coroutine.yield(RESUME.ON_SIGNAL);
		
		if tokens_given == gold_token then
			addInventory(inv_desc_gold_token);
			run_super_conversation(flo, "quip_recycle_machine_give_gold_token");
		elseif tokens_given == recycling_award then
			run_super_conversation(flo, "quip_recycle_machine_award");
			game:EarnAward("avenue-flo_recycle");
		else
			addInventory(inv_desc_token);
			token_count = token_count + 1;
		end
	end
	
	if token_count > 0 then
		BAG_INV:SetInventoryOvertextFlags("token", kHAlignRight + kVAlignTop);
		BAG_INV:SetInventoryOvertext("token", tostring(token_count));
	end
		
	game:Set("recyclable_count", recyclable_count);
	game:Set("token_count", token_count);
	game:Set("tokens_given", tokens_given);
	
	run_super_conversation(flo, "quip_recycle_given_token");
	
	local subway_token_count = game:Get("got_subway_token");
	
	if subway_token_count < 1 then
		subway_token_count = 1;
	else
		subway_token_count = subway_token_count + 1;
	end
	
	game:Set("got_subway_token", subway_token_count);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

hole_spec = 
{
	name = "HOLE";
	gfx = { image = "hole" };
	halo = "hole";
	
	command = function(actor)
		--actor:SetPointAtCursor("cursor");
		actor:SetDepthValue(400);
	end;
	
	point_at_fn = function(actor, enter)
		if enter then
			actor:LoadImage("hole_over")
		else
			actor:LoadImage("hole");
		end;
	end;
	
	--[[
	on_click = function(flo, actor)
		local item = game:GetInvUsage();
		if item == "recyclable" then
			return RESPONSE.WALKTO;
		elseif item ~= "" then
			--on_use_inv(item, flo, actor, false);
			return RESPONSE.IGNORE;
		end
	end;
	--]]
	on_use_inv = function(item, flo, actor)
		if item == "recyclable" then
			if game:Get("recyclable_count") >= 15 then
				flo:StartProc(machine_give_token);
				return RESPONSE.INV_HANDLED;
			else
				convproc("FLO", "quip_recycle_need_more_items");
				return RESPONSE.INV_UNHANDLED;
			end
		else
			convproc("FLO", "quip_recycle_machine_invalid_item");
			return RESPONSE.INV_HANDLED;
		end
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_recycle_machine_hole_click");
	end;
};

token_spec = 
{
	name = "TOKEN";
	gfx = { image = "token" };
	
	command = function(actor)
		actor:SetDepthValue(300);
		actor:JumpToNamedPoint("token_start");
		
		local accel = 0.5;
		local fall_dist = 45;
		local dist = 0;
		local speed = 0;
		local position = actor:GetPosition();
		
		while dist < fall_dist do
			speed = speed + accel;
			dist = dist + speed;
			position.y = position.y + speed;
			
			actor:JumpToPoint(position);
			delay(1);
		end
		
		sfx:PlaySFX("audio/sfx/recycle_token.ogg");
		
		delay(30);
		
		-- play sound here as token comes to rest
		scene.FLO:Signal();
		actor:Expire();
	end;
};

recycle_machine_label_spec = 
{
	name = "RECYCLE_MACHINE_LABEL";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
		actor:AddFlag(AFLAG.AFLAG_NO_VOX);
		actor:SetDepthValue(410);
		actor:JumpToPoint { x = 270, y = 75 };
		actor:ModifySaySpec(machine_label_text);
		actor:ModifySaySpec
		{
			w = 400,
			h = 60,
			lineheight = 20,
			anchor = ANCHOR.TOP;
			halign = HALIGN.LEFT,
			fixed = true,
		};
		actor:SayRaw(scene:grabstring("recycle_machine_label"));
	end;
}

recycle_machine_message1_spec = 
{
	name = "RECYCLE_MACHINE_MESSAGE1";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
		actor:AddFlag(AFLAG.AFLAG_NO_VOX);
		actor:SetDepthValue(410);
		actor:JumpToPoint { x = 260, y = 130 };
		actor:ModifySaySpec(machine_label_text);
		actor:ModifySaySpec
		{
			w = 230,
			h = 100,
			lineheight = 22,
			anchor = ANCHOR.TOP;
			fixed = true,
		};
		actor:SayRaw(scene:grabstring("recycle_machine_message1"));
	end;
}

recycle_machine_message2_spec = 
{
	name = "RECYCLE_MACHINE_MESSAGE2";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
		actor:AddFlag(AFLAG.AFLAG_NO_VOX);
		actor:SetDepthValue(410);
		actor:JumpToPoint { x = 450, y = 180 };
		actor:ModifySaySpec(machine_label_text);
		actor:ModifySaySpec
		{
			w = 100,
			h = 100,
			lineheight = 22,
			anchor = ANCHOR.TOP;
			halign = HALIGN.LEFT,
			fixed = true,
		};
		actor:SayRaw(scene:grabstring("recycle_machine_message2"));
	end;
}

machine_body_spec =
{
	name = "MACHINE_BODY";
	halo = "machine_body";
	
	command = function(actor)
		actor:SetDepthValue(100);
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_recycle_machine_body_click");
	end;
	
	on_use_inv = function(item, flo, actor)
		convproc("FLO", "quip_recycle_machine_invalid_inventory");
		return RESPONSE.INV_HANDLED;
	end;
};

machine_slot_spec =
{
	name = "MACHINE_SLOT";
	halo = "slot";
	
	command = function(actor)
		actor:SetDepthValue(150);
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_recycle_machine_slot_click");
	end;
	
	on_use_inv = function(item, flo, actor)
		convproc("FLO", "quip_recycle_machine_wrong_hole");
		return RESPONSE.INV_HANDLED;
	end;
};

machine_face_spec =
{
	name = "MACHINE_FACE";
	halo = "machine_face";
	
	command = function(actor)
		actor:SetDepthValue(100);
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_recycle_machine_face_click");
	end;
	
	on_use_inv = function(item, flo, actor)
		convproc("FLO", "quip_recycle_machine_invalid_inventory");
		return RESPONSE.INV_HANDLED;
	end;
};

back_spec = 
{
	name = "BACK";
	halo = "background";
	--point_at_name = "back";
	point_at_color = { a  = 1, r = 1, g = 0, b = 0 };
	
	command = function(actor)
		actor:SetDepthValue(0);
		actor:SetPointAtCursor("cursor_exit");
	end;
	
	on_arrive = function(flo, actor)
		sfx:PlaySFX("audio/sfx/checklist_zoom2.ogg");
		scene:ReturnFromScene();
	end;
	
	on_use_inv = function(item, flo, actor)
		game:ClearInvUsage();
		sfx:PlaySFX("audio/sfx/checklist_zoom2.ogg");
		scene:ReturnFromScene();
		return RESPONSE.INV_HANDLED;
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		--sfx:SetMusic("audio/music/office.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up(true, true);
		
		if IsCheatMode() then
			-- testing data
		end
		
		sfx:PlaySFX("audio/sfx/checklist_zoom1.ogg");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "token_overlay", 305 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		recycle_machine_spec,
		hole_spec,
		recycle_machine_label_spec,
		recycle_machine_message1_spec,
		recycle_machine_message2_spec,
		machine_body_spec,
		machine_slot_spec,
		machine_face_spec,
		back_spec,
		
		scene_setup,
	};
};
